		function [csd, w] = INTEGER_2_CSD(i_vec, w);

		% 	Converts integers to Canonic Signed Digit representation 
		%   i_vec : 	a vector of integers
		%   w     : 	the number of bits ('minimum' if not specified)
		% 
		% See "HWP: A new insight into canonical signed digit," ISCAS 2004
		% 
		% Example: INTEGER_2_CSD([13 -13], 7)
		% ans =
		%      0     0     1     0    -1     0     1
		%      0     0    -1     0     1     0    -1
		
		% 	Toolbox for DIGITAL FILTERS USING MATLAB 
		
		% Author: 			Kenny Johansson 2005-08-24
		% Modified by: 		
		% Copyright:		by authors - not released for commercial use
		% Version:			1 
		% Known bugs:		None
		% Report bugs to:	Wanhammar@gmail.com
		%
		
		if ~isnumeric(i_vec)
			error('The input must be in numeric format!');
		end
	
		if min(size(i_vec)) > 1
			error('The input must be a vector!');
		end
	
		if any(round(i_vec) ~= i_vec)
			error('This function only works on integers!');
		end
	
		% Find rows corresponding to negative values
		neg_rows = find(i_vec < 0);
		d_vec = abs(i_vec);
		
		% Set wordlength
		if nargin < 2
			w = ceil(log2(max(i_vec))) + 1;
		end
	
		% Generate S(i) table
		i = 0:w;
		S_tab = 2/3*2.^(i + 1).*(1 - (-0.5).^(i + 1)) - ~mod(i, 2);
		
		% Convert each integer
		csd = zeros(length(i_vec), w);
		for j = 1:length(i_vec)
			% Step 1. Initialize
			d = i_vec(j);
			sign = 1;
			while d
				% Step 2. Search for the row index i
				i = sum(S_tab < d);
				% Update result
				csd(j, w - i) = sign;
				d = d - 2^i;
				% Step 3. Find the sign
				if d < 0
					d = -d;
					sign = -sign;
				end
				% Step 4. Repeat until d = 0
			end
		end
	
		% Compensate for negative values
		csd(neg_rows, :) = -1*csd(neg_rows, :);
